<?php
/* --------------------------------------------------------------
   RomaniaVatIdValidator.php 2024-06-03
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\VatValidation\App\Validators;

/**
 * Class RomaniaVatIdValidator
 *
 * @package Gambio\Core\VatValidation\App\Validators
 */
class RomaniaVatIdValidator implements ManualVatIdValidator
{
    /**
     * @inheritDoc
     */
    public function validatedCountryIsoCode(): string
    {
        return 'ro';
    }
    
    
    /**
     * @inheritDoc
     */
    public function validateVatId(string $vatId): bool
    {
        return preg_match("/^ro[1-9][0-9]{0,9}$/", strtolower($vatId)) === 1;
    }
}